﻿using System;
using System.Data;
using System.Configuration;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using ext = Ext.Net;

/// <summary>
/// Renders and handles the Patient Treatment Tree
/// </summary>
public class CTxTree
{
    protected BaseMaster m_BaseMstr { set; get; }

    /// <summary>
    /// Constructor to create a new instance object for the class 
    /// </summary>
    /// <param name="BaseMstr"></param>
    public CTxTree(BaseMaster BaseMstr)
	{
        m_BaseMstr = BaseMstr;
	}

    /* ------------------------------ */
    #region TreeNodes


    /// <summary>
    /// Renders the pathway events node
    /// </summary>
    /// <param name="lPWID"></param>
    /// <param name="nParentNode"></param>
    public void RenderPWEvents(long lPatPWID, ext.Node nParentNode) 
    {
        DataSet ds = this.GetPWEventsDS(lPatPWID);
        if(ds != null){
            foreach (DataTable dt in ds.Tables) {
                foreach (DataRow dr in dt.Rows) {
                    if (!dr.IsNull("EVENT_TITLE")) { 
                        
                        //create the event node
                        ext.Node nPWEvt = new ext.Node() { 
                            Text = dr["EVENT_TITLE"].ToString(),
                            EmptyChildren = true,
                            Expanded = true
                        };

                        //render event instruments node
                        this.RenderEventInstruments(lPatPWID, Convert.ToInt32(dr["PW_EVENT_ID"]), nPWEvt);

                        nPWEvt.Icon = (nPWEvt.Children.Count > 0) ? ext.Icon.FolderPage : ext.Icon.Folder;

                        //add event node to the parent node
                        nParentNode.Children.Add(nPWEvt);

                    }
                }
            }
        }
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="strPWID"></param>
    /// <param name="nParentNode"></param>
    public void RenderPWEvents(string strPWID, ext.Node nParentNode)
    {
        DataSet ds = this.GetPWEventsDS(strPWID);
        if (ds != null)
        {
            foreach (DataTable dt in ds.Tables)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (!dr.IsNull("EVENT_TITLE"))
                    {

                        //create the event node
                        ext.Node nPWEvt = new ext.Node()
                        {
                            Text = dr["EVENT_TITLE"].ToString(),
                            EmptyChildren = true,
                            Expanded = false,
                            CustomAttributes = { 
                                new ext.ConfigItem{
                                    Name = "is_event",
                                    Value = "true",
                                    Mode = ext.ParameterMode.Auto
                                },
                                new ext.ConfigItem{
                                    Name = "is_instrument",
                                    Value = "false",
                                    Mode = ext.ParameterMode.Auto
                                },
                                 new ext.ConfigItem{
                                    Name = "pat_pw_id",
                                    Value = dr["PAT_PW_ID"].ToString(),
                                    Mode = ext.ParameterMode.Auto
                                },
                                new ext.ConfigItem{
                                    Name = "pat_pw_event_id",
                                    Value = dr["PAT_PW_EVENT_ID"].ToString(),
                                    Mode = ext.ParameterMode.Auto
                                }
                            }
                        };

                        //render event instruments node
                        this.RenderEventInstruments(Convert.ToInt32(dr["PAT_PW_ID"]), Convert.ToInt32(dr["PAT_PW_EVENT_ID"]), nPWEvt);

                        nPWEvt.Icon = (nPWEvt.Children.Count > 0) ? ext.Icon.FolderPage : ext.Icon.Folder;

                        //add event node to the parent node
                        nParentNode.Children.Add(nPWEvt);

                    }
                }
            }
        }
    }

    /// <summary>
    /// Render the event instruments node
    /// </summary>
    /// <param name="lPWID"></param>
    /// <param name="lEVTID"></param>
    /// <param name="nParentNode"></param>
    protected void RenderEventInstruments(long lPWID, long lEVTID, ext.Node nParentNode) 
    {
        DataSet ds = this.GetEventInstruments(lPWID, lEVTID);
        if (ds != null) {
            foreach (DataTable dt in ds.Tables) {
                foreach (DataRow dr in dt.Rows) { 
                    if(!dr.IsNull("MODULE")){

                        string strModName = String.Empty;

                        if (!dr.IsNull("ACRONYM"))
                        {
                            strModName += dr["ACRONYM"].ToString() + " ";
                        }

                        strModName += dr["MODULE"].ToString();

                        //create the instrument node
                        ext.Node nInstr = new ext.Node()
                        {
                            Text = strModName,
                            Leaf = true,
                            EmptyChildren = true,
                            Icon = ext.Icon.Page,
                            CustomAttributes = { 
                                new ext.ConfigItem{
                                    Name = "is_event",
                                    Value = "false",
                                    Mode = ext.ParameterMode.Auto
                                },
                                new ext.ConfigItem{
                                    Name = "is_instrument",
                                    Value = "true",
                                    Mode = ext.ParameterMode.Auto
                                },
                                new ext.ConfigItem{
                                    Name = "patient_id",
                                    Value = m_BaseMstr.SelectedPatientID,
                                    Mode = ext.ParameterMode.Value
                                },
                                new ext.ConfigItem{
                                    Name = "item_type",
                                    Value = "evt_instrument",
                                    Mode = ext.ParameterMode.Value
                                },
                                new ext.ConfigItem{
                                    Name = "mid",
                                    Value = dr["MID"].ToString(),
                                    Mode = ext.ParameterMode.Value
                                },
                                new ext.ConfigItem{
                                    Name = "intake_id",
                                    Value = (!dr.IsNull("INTAKE_ID")) ? dr["INTAKE_ID"].ToString() : "0",
                                    Mode = ext.ParameterMode.Value
                                },
                                new ext.ConfigItem{
                                    Name = "status",
                                    Value = (!dr.IsNull("STATUS")) ? dr["STATUS"].ToString() : "0",
                                    Mode = ext.ParameterMode.Value
                                },
                                new ext.ConfigItem{
                                    Name = "region_id",
                                    Value = dr["region_id"].ToString(),
                                    Mode = ext.ParameterMode.Value
                                },
                                new ext.ConfigItem{
                                    Name = "site_id",
                                    Value = dr["site_id"].ToString(),
                                    Mode = ext.ParameterMode.Value
                                },
                                new ext.ConfigItem{
                                    Name = "pat_pw_id",
                                    Value = dr["pat_pw_id"].ToString(),
                                    Mode = ext.ParameterMode.Value
                                },
                                new ext.ConfigItem{
                                    Name = "pat_pw_event_id",
                                    Value = dr["pat_pw_event_id"].ToString(),
                                    Mode = ext.ParameterMode.Value
                                },
                                new ext.ConfigItem{
                                    Name = "pw_event_module_id",
                                    Value = dr["pw_event_module_id"].ToString(),
                                    Mode = ext.ParameterMode.Value
                                }
                            }
                        };

                        if (Convert.ToInt32(dr["STATUS"]) == 1) {
                            nInstr.Icon = ext.Icon.Tick;
                        }

                        //add the instrument node to the parent node
                        nParentNode.Children.Add(nInstr);
                    }
                }
            }
        }
    }

    #endregion

    /* ------------------------------ */
    #region GetDataSets

    /// <summary>
    /// Gets the dataset to build the Pathway Events node
    /// </summary>
    /// <returns></returns>
    protected DataSet GetPWEventsDS(long lPWID)
    {
        CCPA ccpa = new CCPA();
        var ds = ccpa.GetPatPWEventDS(m_BaseMstr, m_BaseMstr.SelectedPatientID, lPWID);
        return ds;
    }

    protected DataSet GetPWEventsDS(string strPWList)
    {
        CCPA ccpa = new CCPA();
        var dsOriginal = ccpa.GetPatPWEventDS(m_BaseMstr, m_BaseMstr.SelectedPatientID);

        if (strPWList.Length > 1)
        {
            strPWList = "," + strPWList;
            DataSet dsNew = null;

            if (dsOriginal != null)
            {
                if (dsOriginal.Tables.Count > 0)
                {
                    dsNew = new DataSet()
                    {
                        Tables = { 
                            dsOriginal.Tables[0].Clone()
                        }
                    };

                    foreach (DataRow dr in dsOriginal.Tables[0].Rows)
                    {
                        if (!dr.IsNull("PAT_PW_ID"))
                        {
                            string strPatPWID = "," + dr["PAT_PW_ID"].ToString() + ",";
                            if (strPWList.IndexOf(strPatPWID) > -1)
                            {
                                DataRow drNew = dsNew.Tables[0].NewRow();
                                for (int a = 0; a < dsNew.Tables[0].Columns.Count; a++)
                                {
                                    drNew[a] = dr[a];
                                }
                                dsNew.Tables[0].Rows.Add(drNew);
                            }
                        }
                    }
                    dsNew.Tables[0].AcceptChanges();
                    dsNew.AcceptChanges();
                }
            }
            return dsNew;
        }

        return dsOriginal;

    }

    /// <summary>
    /// Gets dataset of all pathway events associated with a patient
    /// </summary>
    /// <param name="lPWID"></param>
    /// <returns></returns>
    protected DataSet GetPWEventsDS()
    {
        CCPA ccpa = new CCPA();
        var ds = ccpa.GetPatPWEventDS(m_BaseMstr, m_BaseMstr.SelectedPatientID);
        return ds;
    }

    /// <summary>
    /// Gets the dataset to build the Pathway Event Instruments node
    /// </summary>
    /// <param name="lEVTID"></param>
    /// <returns></returns>
    protected DataSet GetEventInstruments(long lPWID, long lEVTID) 
    {
        CCPA ccpa = new CCPA();
        var ds = ccpa.GetPatPWEventModuleDS(m_BaseMstr, m_BaseMstr.SelectedPatientID, lPWID, lEVTID);
        if (ds != null) {
            ds = FilterInstrumentsList(ds);
        }
        return ds;
    }

    #endregion

    /// <summary>
    /// filter instruments list
    /// </summary>
    /// <param name="ds"></param>
    /// <returns></returns>
    protected DataSet FilterInstrumentsList(DataSet ds)
    {
        if (ds != null)
        {
            DataSet dsNew = new DataSet();
            dsNew.Tables.Add(ds.Tables[0].Clone());
            DataRow[] drArr = ds.Tables[0].Select("module_for = 1 OR module_for = 3");
            foreach (DataRow dr in drArr)
            {
                DataRow drNew = dsNew.Tables[0].NewRow();
                foreach (DataColumn dc in dsNew.Tables[0].Columns)
                {
                    drNew[dc.ColumnName] = dr[dc.ColumnName];
                }
                dsNew.Tables[0].Rows.Add(drNew);
            }
            return dsNew;
        }
        return null;
    }
}